# DX_CC6_CORE_HOST_SIDE makefile
# NVS component
#

COMP_NAME := $(NVS_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(VOS_ID) $(CC6_GEN_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)NVS/inc/

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)NVS/NVS_DualCore/NVS_Host/inc/

#global flags for this component
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	NVS_$(NVS_TYPE) nvs_host nvs_debug nvs_version

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(NVS_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)NVS_$(NVS_TYPE).$(OBJEXT): $(HOST_PATH)NVS/NVS_$(NVS_TYPE)/src/NVS_$(NVS_TYPE).c
	$(NVS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)nvs_host.$(OBJEXT): $(HOST_PATH)NVS/NVS_DualCore/NVS_Host/src/nvs_host.c
	$(NVS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)nvs_debug.$(OBJEXT): $(HOST_PATH)NVS/src/nvs_debug.c
	$(NVS_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)nvs_version.$(OBJEXT): $(HOST_PATH)NVS/src/nvs_version.c
	$(NVS_CC_CMD) $< $(CCFLAG_OUTPUT) $@


